/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.update;

import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.update.ModuleInfo;
import DE.siemens.ad.logo.dialog.wizard.update.UpdateWizardModel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoIOException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectModulesPanel
extends WizardInputPanel {
    private JLabel ivjlblAvailableModules = null;
    private JLabel ivjlblChooseCategory = null;
    private JScrollPane ivjspAvailable = null;
    private JTextArea ivjtaDescription = null;
    private JComboBox ivjcoxChooseCategory = null;
    private JList ivjlAvailable = null;
    private JLabel ivjlblDescription = null;
    private JPanel ivjavailablePanel = null;
    private JPanel ivjcategoryPanel = null;
    private JPanel ivjdescriptionPanel = null;
    private JScrollPane ivjspDescription = null;
    private JPanel ivjJPanel1 = null;

    public SelectModulesPanel(WizardPanelModel panelModel) {
        super(panelModel);
        this.initialize();
        this.gettaDescription().setBackground(UIManager.getColor("Panel.background"));
        this.gettaDescription().setEditable(false);
        this.getcoxChooseCategory().setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setIcon(null);
                String type = (String)value;
                if (type.equals("language")) {
                    this.setIcon(Global.getIcon("Language.gif"));
                }
                if (type.equals("addon")) {
                    this.setIcon(Global.getIcon("AddOn.gif"));
                }
                if (type.equals("servicepack")) {
                    this.setIcon(Global.getIcon("ServicePack.gif"));
                }
                if (type.equals("upgrade")) {
                    this.setIcon(Global.getIcon("Upgrade.gif"));
                }
                if (type.equals("addon")) {
                    type = "addOn";
                }
                this.setText(Language.getString("wizard.update.categories." + type, type));
                return this;
            }
        });
        this.getcoxChooseCategory().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                SelectModulesPanel.this.loadAvailableModules();
            }
        });
        this.getlAvailable().setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ModuleInfo moduleInfo = (ModuleInfo)value;
                this.setIcon(null);
                String type = moduleInfo.getType();
                if (type.equalsIgnoreCase("language")) {
                    this.setIcon(Global.getIcon("Language.gif"));
                }
                if (type.equalsIgnoreCase("addon")) {
                    this.setIcon(Global.getIcon("AddOn.gif"));
                }
                if (type.equalsIgnoreCase("servicepack")) {
                    this.setIcon(Global.getIcon("ServicePack.gif"));
                }
                if (type.equalsIgnoreCase("upgrade")) {
                    this.setIcon(Global.getIcon("Upgrade.gif"));
                }
                if (type.equalsIgnoreCase("addon")) {
                    type = "addOn";
                }
                this.setText(moduleInfo.getName() + " (" + Language.getString("wizard.update.categories." + type, type) + ")");
                return this;
            }
        });
        this.getlAvailable().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (SelectModulesPanel.this.getlAvailable().getSelectedIndices().length != 1) {
                    SelectModulesPanel.this.gettaDescription().setText("");
                } else {
                    SelectModulesPanel.this.gettaDescription().setText(SelectModulesPanel.this.insertCarriageReturn(((ModuleInfo)SelectModulesPanel.this.getlAvailable().getSelectedValue()).getDescription()));
                }
            }
        });
    }

    public boolean checkFieldContents() {
        if (this.getlAvailable().getSelectedIndices().length == 0) {
            JOptionPane.showMessageDialog(this, Language.getString("wizard.update.selectModulesPanel.noModulesSelected", "You must at least select one Module"), this.getTitle(), 1);
            return false;
        }
        return true;
    }

    private JPanel getavailablePanel() {
        if (this.ivjavailablePanel == null) {
            try {
                this.ivjavailablePanel = new JPanel();
                this.ivjavailablePanel.setName("availablePanel");
                this.ivjavailablePanel.setLayout(new BorderLayout());
                this.getavailablePanel().add((Component)this.getlblAvailableModules(), "North");
                this.getavailablePanel().add((Component)this.getspAvailable(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjavailablePanel;
    }

    private JPanel getcategoryPanel() {
        if (this.ivjcategoryPanel == null) {
            try {
                this.ivjcategoryPanel = new JPanel();
                this.ivjcategoryPanel.setName("categoryPanel");
                this.ivjcategoryPanel.setLayout(new BorderLayout());
                this.getcategoryPanel().add((Component)this.getlblChooseCategory(), "North");
                this.getcategoryPanel().add((Component)this.getcoxChooseCategory(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjcategoryPanel;
    }

    private JComboBox getcoxChooseCategory() {
        if (this.ivjcoxChooseCategory == null) {
            try {
                this.ivjcoxChooseCategory = new JComboBox();
                this.ivjcoxChooseCategory.setName("coxChooseCategory");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjcoxChooseCategory;
    }

    private JPanel getdescriptionPanel() {
        if (this.ivjdescriptionPanel == null) {
            try {
                this.ivjdescriptionPanel = new JPanel();
                this.ivjdescriptionPanel.setName("descriptionPanel");
                this.ivjdescriptionPanel.setLayout(new BorderLayout());
                this.getdescriptionPanel().add((Component)this.getlblDescription(), "North");
                this.getdescriptionPanel().add((Component)this.getspDescription(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjdescriptionPanel;
    }

    public Icon getIcon() {
        return null;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints constraintsavailablePanel = new GridBagConstraints();
                constraintsavailablePanel.gridx = 0;
                constraintsavailablePanel.gridy = 0;
                constraintsavailablePanel.fill = 1;
                constraintsavailablePanel.weightx = 1.0;
                constraintsavailablePanel.weighty = 1.0;
                constraintsavailablePanel.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getavailablePanel(), constraintsavailablePanel);
                GridBagConstraints constraintsdescriptionPanel = new GridBagConstraints();
                constraintsdescriptionPanel.gridx = 0;
                constraintsdescriptionPanel.gridy = 1;
                constraintsdescriptionPanel.fill = 1;
                constraintsdescriptionPanel.weightx = 1.0;
                constraintsdescriptionPanel.ipady = 60;
                constraintsdescriptionPanel.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getdescriptionPanel(), constraintsdescriptionPanel);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JList getlAvailable() {
        if (this.ivjlAvailable == null) {
            try {
                this.ivjlAvailable = new JList();
                this.ivjlAvailable.setName("lAvailable");
                this.ivjlAvailable.setBounds(0, 0, 160, 120);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlAvailable;
    }

    private JLabel getlblAvailableModules() {
        if (this.ivjlblAvailableModules == null) {
            try {
                this.ivjlblAvailableModules = new JLabel();
                this.ivjlblAvailableModules.setName("lblAvailableModules");
                this.ivjlblAvailableModules.setText("Verf\u00fcgbare Module");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlblAvailableModules;
    }

    private JLabel getlblChooseCategory() {
        if (this.ivjlblChooseCategory == null) {
            try {
                this.ivjlblChooseCategory = new JLabel();
                this.ivjlblChooseCategory.setName("lblChooseCategory");
                this.ivjlblChooseCategory.setText("Kategorie ausw\u00e4hlen");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlblChooseCategory;
    }

    private JLabel getlblDescription() {
        if (this.ivjlblDescription == null) {
            try {
                this.ivjlblDescription = new JLabel();
                this.ivjlblDescription.setName("lblDescription");
                this.ivjlblDescription.setText("JLabel1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlblDescription;
    }

    private JScrollPane getspAvailable() {
        if (this.ivjspAvailable == null) {
            try {
                this.ivjspAvailable = new JScrollPane();
                this.ivjspAvailable.setName("spAvailable");
                this.getspAvailable().setViewportView(this.getlAvailable());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjspAvailable;
    }

    private JScrollPane getspDescription() {
        if (this.ivjspDescription == null) {
            try {
                this.ivjspDescription = new JScrollPane();
                this.ivjspDescription.setName("spDescription");
                this.getspDescription().setViewportView(this.gettaDescription());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjspDescription;
    }

    private JTextArea gettaDescription() {
        if (this.ivjtaDescription == null) {
            try {
                this.ivjtaDescription = new JTextArea();
                this.ivjtaDescription.setName("taDescription");
                this.ivjtaDescription.setLineWrap(true);
                this.ivjtaDescription.setWrapStyleWord(true);
                this.ivjtaDescription.setBounds(0, 0, 10, 10);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjtaDescription;
    }

    private void handleException(Throwable exception) {
    }

    public void handleProcessException(Exception e) {
        String errorText = null;
        if (e instanceof LogoIOException && ((LogoIOException)e).getType().equals("cantWrite")) {
            errorText = Language.getString("wizard.update.selectModulesPanel.error.cantWrite", "The file could not be written.");
        }
        if (errorText == null && e instanceof FileNotFoundException) {
            errorText = Language.getString("wizard.update.selectModulesPanel.error.fileNotFound", "The requested update file was not found.");
        }
        if (errorText == null && e instanceof IOException && e.getMessage() != null && e.getMessage().equals("cantWrite")) {
            errorText = Language.getString("wizard.update.selectModulesPanel.error.cantWrite", "The requested update file was not found.");
        }
        if (errorText == null) {
            super.handleProcessException(e);
            return;
        }
        if (e instanceof LogoIOException && ((LogoIOException)e).getFile() != null) {
            errorText = errorText + "\n\n" + ((LogoIOException)e).getFile().getPath();
        }
        JOptionPane.showMessageDialog(this, errorText, this.getTitle(), 0);
    }

    private void initialize() {
        try {
            this.setName("SelectModulesPanel");
            this.setLayout(new GridBagLayout());
            this.setSize(469, 462);
            GridBagConstraints constraintscategoryPanel = new GridBagConstraints();
            constraintscategoryPanel.gridx = 0;
            constraintscategoryPanel.gridy = 0;
            constraintscategoryPanel.fill = 1;
            constraintscategoryPanel.weightx = 1.0;
            constraintscategoryPanel.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.getcategoryPanel(), constraintscategoryPanel);
            GridBagConstraints constraintsJPanel1 = new GridBagConstraints();
            constraintsJPanel1.gridx = 0;
            constraintsJPanel1.gridy = 1;
            constraintsJPanel1.fill = 1;
            constraintsJPanel1.weightx = 1.0;
            constraintsJPanel1.weighty = 1.0;
            constraintsJPanel1.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.getJPanel1(), constraintsJPanel1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    protected String insertCarriageReturn(String string) {
        StringBuffer buffer = new StringBuffer(string);
        int index = -1;
        while ((index = buffer.toString().indexOf("\\n")) != -1) {
            buffer.replace(index, index + 2, "\n");
        }
        return buffer.toString();
    }

    public void loadAvailableModules() {
        UpdateWizardModel updateModel = (UpdateWizardModel)this.panelModel.getWizardModel();
        Vector availableModules = updateModel.getAvailableModules();
        Object choosedCategory = this.getcoxChooseCategory().getSelectedItem();
        DefaultListModel<ModuleInfo> availableModulesListModel = new DefaultListModel<ModuleInfo>();
        Enumeration e = availableModules.elements();
        while (e.hasMoreElements()) {
            ModuleInfo moduleInfo = (ModuleInfo)e.nextElement();
            if (!choosedCategory.equals("allCategories") && !choosedCategory.equals(moduleInfo.getType())) continue;
            availableModulesListModel.addElement(moduleInfo);
        }
        this.getlAvailable().setModel(availableModulesListModel);
    }

    public void loadFieldContents() {
        UpdateWizardModel updateModel = (UpdateWizardModel)this.panelModel.getWizardModel();
        Vector availableModules = updateModel.getAvailableModules();
        Enumeration e = availableModules.elements();
        Vector<String> categories = new Vector<String>();
        while (e.hasMoreElements()) {
            ModuleInfo moduleInfo = (ModuleInfo)e.nextElement();
            if (categories.contains(moduleInfo.getType())) continue;
            categories.add(moduleInfo.getType());
        }
        DefaultComboBoxModel<String> categoriesModel = new DefaultComboBoxModel<String>();
        categoriesModel.addElement("allCategories");
        e = categories.elements();
        while (e.hasMoreElements()) {
            categoriesModel.addElement((String)e.nextElement());
        }
        this.getcoxChooseCategory().setModel(categoriesModel);
        this.loadAvailableModules();
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            SelectModulesPanel aSelectModulesPanel = new SelectModulesPanel(null);
            frame.setContentPane(aSelectModulesPanel);
            frame.setSize(aSelectModulesPanel.getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of DE.siemens.ad.logo.dialog.wizard.WizardInputPanel");
            exception.printStackTrace(System.out);
        }
    }

    public void processingFinished() {
        if (((UpdateWizardModel)this.panelModel.getWizardModel()).getUpdateMode() == 0) {
            JOptionPane.showMessageDialog(this, Language.getString("wizard.update.selectModulesPanel.disconnectInternet", "File transmission successfull.\nYou can know disconnect the internet connection."), this.getTitle(), 1);
        }
    }

    public void setLabels() {
        this.setTitle(Language.getString("wizard.update.selectModulesPanel.title", "Module Selection"));
        this.getlblChooseCategory().setText(Language.getString("wizard.update.selectModulesPanel.categorie", "Categorie"));
        this.getlblAvailableModules().setText(Language.getString("wizard.update.selectModulesPanel.availableModules", "Available Modules"));
        this.getlblDescription().setText(Language.getString("wizard.update.selectModulesPanel.moduleDescription", "Description"));
    }

    public void storeFieldContents() {
        Vector<Object> v = new Vector<Object>();
        Object[] selectedValues = this.getlAvailable().getSelectedValues();
        for (int i = 0; i < selectedValues.length; ++i) {
            v.add(selectedValues[i]);
        }
        ((UpdateWizardModel)this.panelModel.getWizardModel()).setSelectedModules(v);
    }
}

